/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.recipe.drink;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.craft.FluidIngredient;
import xueluoanping.teastory.registry.RecipeRegister;

public class DrinkRecipe
implements Recipe<RecipeWrapper> {
    protected final ResourceLocation id;
    protected final String group;
    protected final NonNullList<Ingredient> ingredients;
    protected final FluidIngredient fluidIngredient;
    protected final Fluid result;

    public DrinkRecipe(ResourceLocation idIn, String groupIn, NonNullList<Ingredient> ingredientIn, FluidIngredient fluidIn, Fluid resultIn) {
        this.id = idIn;
        this.group = groupIn;
        this.ingredients = ingredientIn;
        this.fluidIngredient = fluidIn;
        this.result = resultIn;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        ArrayList inputs = Lists.newArrayList();
        return FluidUtil.getFluidHandler((ItemStack)inv.m_8020_(8).m_41777_()).map(h -> {
            if (this.fluidIngredient.getMatchingFluidStacks().isEmpty()) {
                return false;
            }
            boolean flag = false;
            for (FluidStack fluidStack : this.fluidIngredient.getMatchingFluidStacks()) {
                if (!h.getFluidInTank(0).containsFluid(fluidStack)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
            for (int j = 0; j < 4; ++j) {
                ItemStack itemstack = inv.m_8020_(j).m_41777_();
                if (itemstack.m_41619_()) continue;
                inputs.add(itemstack);
            }
            return RecipeMatcher.findMatches((List)inputs, this.ingredients) != null;
        }).orElse(false);
    }

    public ItemStack assemble(RecipeWrapper inv, RegistryAccess p_267165_) {
        return FluidUtil.getFluidHandler((ItemStack)inv.m_8020_(8).m_41777_()).map(h -> {
            ItemStack container = inv.m_8020_(8).m_41777_();
            CompoundTag fluidTag = new CompoundTag();
            new FluidStack(this.result, h.getFluidInTank(0).getAmount()).writeToNBT(fluidTag);
            container.m_41784_().m_128365_("Fluid", (Tag)fluidTag);
            return container;
        }).orElse(ItemStack.f_41583_);
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(RecipeWrapper inv) {
        return NonNullList.m_122783_((Object)FluidUtil.getFluidHandler((ItemStack)inv.m_8020_(8).m_41777_()).map(h -> {
            ItemStack container = inv.m_8020_(8).m_41777_();
            CompoundTag fluidTag = new CompoundTag();
            new FluidStack(this.result, h.getFluidInTank(0).getAmount()).writeToNBT(fluidTag);
            container.m_41784_().m_128365_("Fluid", (Tag)fluidTag);
            return container;
        }).orElse(ItemStack.f_41583_), (Object[])new ItemStack[0]);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public Fluid getFluidResult() {
        return this.result;
    }

    public FluidIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public int getFluidAmount() {
        return this.fluidIngredient.getMatchingFluidStacks().get(0).getAmount();
    }

    public String m_6076_() {
        return this.group;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegister.DRINK_MAKER_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegister.DRINK_MAKER.get();
    }

    public static class DrinkRecipeSerializer
    extends NewRegistryEvent
    implements RecipeSerializer<DrinkRecipe> {
        private static NonNullList<Ingredient> readIngredients(JsonArray array) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)array.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public DrinkRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = json.has("group") ? json.get("group").getAsString() : "";
            NonNullList<Ingredient> ingredients = DrinkRecipeSerializer.readIngredients(json.getAsJsonArray("item_ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for drink recipe");
            }
            FluidIngredient fluidIngredient = FluidIngredient.deserialize(json.get("fluid_ingredient"));
            Fluid result = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(json.get("drink_result").getAsString()));
            if (result == null || result == Fluids.f_76191_) {
                throw new JsonSyntaxException("Result cannot be null");
            }
            return new DrinkRecipe(recipeId, group, ingredients, fluidIngredient, result);
        }

        @Nullable
        public DrinkRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int i = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            FluidIngredient fluidIngredient = FluidIngredient.read(buffer);
            Fluid result = buffer.readFluidStack().getFluid();
            return new DrinkRecipe(recipeId, group, (NonNullList<Ingredient>)ingredients, fluidIngredient, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, DrinkRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            recipe.getFluidIngredient().write(buffer);
            buffer.writeFluidStack(new FluidStack(recipe.getFluidResult(), 1));
        }
    }
}

